<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateUsersFields extends Migration
{
    /**
     * @return void
     * @throws \Drupal\Core\Entity\EntityStorageException
     * @throws \Inside\Host\Exceptions\ColumnAlreadyExistsException
     */
    public function up()
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'cities',
            [
                'name' => 'cities',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Ville',
                    'en' => 'City',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['cities'],
                    'cardinality' => 1,
                ]
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'address',
            [
                'name' => 'address',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 60,
                'title' => [
                    'fr' => 'Adresse postale',
                    'en' => 'Address',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 60,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'office_location',
            [
                'name' => 'office_location',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 60,
                'title' => [
                    'fr' => 'Emplacement du bureau',
                    'en' => 'Office location',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 60,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
