<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class UpdateCertificatesFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('certificates');

        $this->finishUp();

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'projects', 'certificates_ing');
        $bridge->contentTypeDeleteField('node', 'projects', 'certificates_fp');
        $bridge->contentTypeDeleteField('node', 'projects', 'certificates_fi');

        $bridge->contentTypeDelete('certificates_ing');
        $bridge->contentTypeDelete('certificates_fp');
        $bridge->contentTypeDelete('certificates_fi');

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'certificates',
            [
                'name' => 'certificates',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 8,
                'filter_category' => '',
                'weight' => 260,
                'title' => [
                    'fr' => 'Certifications',
                    'en' => 'Certificates',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 260,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['certificates'],
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
