<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixUsersType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $userTypeFields = [
            'tools',
            'birthday',
            'skills',
            'departments',
            'divisions',
            'subsidiaries',
            'function',
            'groups',
            'linkedin',
            'locations',
            'users',
            'mobile_phone',
            'lastname',
            'image',
            'firstname',
            'teams',
            'twitter',
            'phone'
        ];

        foreach ($userTypeFields as $fieldName) {
            $bridge->updateFieldOptions('users', $fieldName, [
                'editable' => true
            ]);
        }

        $bridge->updateContentTypeOptions('divisions', [
            'searchable' => true
        ]);
    }
}
