<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'pages_categories',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Regroupement de page',
            'en' => 'Page grouping',
        ],
    ],
    'fields' => [
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
            ],
            'description' => [
                'fr' => 'Cette image remontera comme une bannière du bloc',
                'en' => 'This image will go up as a banner from the block',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'spaces',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Espace',
                'en' => 'Espace',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle le regroupement doit remonter',
                'en' => 'Choice of the space in which the grouping must go up',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces'],
                'cardinality' => 1,
            ],
        ],
    ],
];
