<?php

namespace Inside\IIDE\Providers;

use Illuminate\Container\Container;
use Inside\IIDE\Console\ImportProjectNewsFromRss;
use Inside\IIDE\Console\ImportProjectsDateLastChangedFromApi;
use Inside\IIDE\Console\ImportProjectsFromApi;
use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Inside\Content\Http\Controllers\External\Index as ExternalIndex;

/**
 * IIDE Service provider.
 *
 * @category Class
 * @package  Inside\IIDE\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__.'/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->app->singleton(
            'command.project.news',
            function (Container $app) {
                return new ImportProjectNewsFromRss();
            }
        );

        $this->app->singleton(
            'command.projects',
            function (Container $app) {
                return new ImportProjectsFromApi();
            }
        );

        $this->app->singleton(
            'command.projects.date',
            function (Container $app) {
                return new ImportProjectsDateLastChangedFromApi();
            }
        );

        $this->commands('command.project.news');
        $this->mergeConfigTo(
            __DIR__ . '/../../config/azuread.php',
            'azuread'
        );
        $this->mergeRecursiveConfigFrom(
            __DIR__ . '/../../config/scheduler.php',
            'scheduler'
        );
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/authentication.php', 'authentication');
        $this->commands('command.projects');
        $this->commands('command.projects.date');
        $this->mergeConfigTo(__DIR__ . '/../../config/notify.php', 'notify');
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/external_api.php', 'external_api');
    }
}
