<div class="container">
    <table>
        <tr class="header">
            <td style="width: 80%"><h1>{{ $headerData->get('title') }}</h1></td>
            <td style="width: 20%">
                @if (!empty($headerData->get('logo')))
                    <img src="data:image/png;base64, {{ base64_encode($headerData->get('logo')) }}" height="60" width="60">
                @endif
            </td>
        </tr>
    </table>
    <br>
    <table>
        <tr class="main">
            <td style="width: 30%">
                @if (!empty($headerData->get('main_image')))
                    <img src="data:image/png;base64, {{ base64_encode($headerData->get('main_image')) }}">
                @endif
            </td>
            <td style="width: 70%"><p>{!! $headerData->get('content') !!}</p></td>
        </tr>
    </table>
    <table>
        <tr class="separator list">
            <td style="width: 50%">
                @foreach($data1 as $label => $value)
                    <p><b>{{ $label }} : </b> {{ $value }}</p>
                @endforeach
            </td>
            <td style="width: 50%">
                @foreach($data2 as $label => $value)
                    <p><b>{{ $label }} : </b> {{ $value }}</p>
                @endforeach
            </td>
        </tr>
    </table>
    @if($sectionData->get('benefits_and_user_comfort') !== null)
        <section>
            <h2>Prestations et confort d'usage</h2>
            <p>{{ $sectionData->get('benefits_and_user_comfort') }}</p>
        </section>
    @endif
    @if($sectionData->get('lease') !== null)
        <section>
            <h2>Mise à bail</h2>
            <p>{{ $sectionData->get('lease') }}</p>
        </section>
    @endif
    @if($sectionData->get('certifications') !== null)
        <section>
            <h2>Certifications</h2>
            <p>{{ $sectionData->get('certifications') }}</p>
        </section>
    @endif
    <section>
        <h2>Adresse</h2>
        @if($sectionData->get('address') !== null)
            <p>{{ $sectionData->get('address') }}</p>
        @endif
        @if($sectionData->get('city') !== null)
            <p>{{ $sectionData->get('city') }}</p>
        @endif
        @if($sectionData->get('country') !== null)
            <p>{{ $sectionData->get('country') }}</p>
        @endif
    </section>
    @if($sectionData->get('our_answer') !== null)
        <section>
            <h2>Réponse</h2>
            <p>{{ $sectionData->get('our_answer') }}</p>
        </section>
    @endif
    <br>
    @if($sectionData->get('commercialFirm') !== null)
    <section>
        <h3>Commercialisation:</h3>
        <table>
            <tr class="separator">
                @foreach($sectionData->get('commercialFirm') as $firm)
                    <td style="width: 50%">
                        <p>{{ $firm->title }}</p>
                        <p>{{ $firm->address }}</p>
                        <p>{{ $firm->zipcode }}</p>
                        <p>{{ $firm->phone }}</p>
                        <p>{{ $firm->phone_mentions }}</p>
                        <p>{{ $firm->opening_time }}</p>
                    </td>
                @endforeach
            </tr>
        </table>
    </section>
    @endif
</div>

<style>
    * {
        text-align: justify;
        font-size: 12px;
    }

    .container {
        color: #333333;
        font-family: "Arial";
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 8px;
    }

    table td {
        vertical-align:top
    }

    h1 {
        font-size:28px;
        font-weight: lighter;
        margin: 0;
    }

    h2 {
        padding: 10px 10px;
        background: #E4E4E4;
        font-weight: bold;
        margin: 4px 0;
    }

    h3 {
        margin: 0;
        font-weight: bold;
    }

    p {
        margin: 0;
    }

    br {
        line-height: 8px;
    }

    section {
        margin-bottom: 8px;
    }

    table .header {
        border-bottom: 2px solid #464646;
    }

    table .header td:last-child {
        text-align: right;
    }

    table .main td:first-child img {
        width: 100%;
    }

    table .main td:last-child p {
        margin: 0 10px;
    }

    table .separator td:last-child {
        padding-left: 10px;
        border-left: 2px solid #999999;
    }

    table .list td > p {
        margin: 8px 10px 0 0;
    }

    table .separator td > p:first-child {
        margin-top: 0;
    }

    table .separator td > p:last-child {
        margin-bottom: 0;
    }
</style>




