<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema as InsideSchema;

class IideTranslateContentTypes extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        collect([
            'blocks' => [
                'fr' => 'Bloc',
                'en' => 'Block',
            ],
            'carpools' => [
                'fr' => 'Covoiturage',
                'en' => 'Carpooling',
            ],
            'cities' => [
                'fr' => 'Villes',
                'en' => 'Cities',
            ],
            'commercial_firms' => [
                'fr' => 'Bureau de vente',
                'en' => 'Commercial firms',
            ],
            'contracts_types' => [
                'fr' => 'Type de contrat',
                'en' => 'Contracts type',
            ],
            'custom' => [
                'fr' => 'Page personnalisée',
                'en' => 'Custom page',
            ],
            'delivery_years' => [
                'fr' => 'Année de livraison',
                'en' => 'Delivery years',
            ],
            'departments' => [
                'fr' => 'Departement',
                'en' => 'Department',
            ],
            'divisions' => [
                'fr' => 'Divisions',
                'en' => 'Divisions',
            ],
            'legal_entities' => [
                'fr' => 'Société juridique et d\'appartenance',
                'en' => 'Legal entity and membership',
            ],
            'locations' => [
                'fr' => 'Localisation',
                'en' => 'Location',
            ],
            'move_hours' => [
                'fr' => 'Heaure de départ',
                'en' => 'Departure time',
            ],
            'pages_categories' => [
                'fr' => 'Regroupement de page',
                'en' => 'Page grouping',
            ],
            'project_types' => [
                'fr' => 'Nature du projets',
                'en' => 'Project Types'
            ],
            'project_types_fp' => [
                'fr' => 'Nature du projet FP',
                'en' => 'FP Project type',
            ],
            'project_types_ing' => [
                'fr' => 'Nature du projet ING',
                'en' => 'ING Project type',
            ],
            'projects_locations' => [
                'fr' => 'Localisation du projet',
                'en' => 'Project location',
            ],
            'projects_statuses' => [
                'fr' => 'Statut du projet',
                'en' => 'Project status',
            ],
            'services' => [
                'fr' => 'Services',
                'en' => 'Services',
            ],
            'spaces' => [
                'fr' => 'Espace',
                'en' => 'Space',
            ],
            'spaces_pages' => [
                'fr' => 'Page métier',
                'en' => 'business page',
            ],
            'statuses' => [
                'fr' => 'Statut',
                'en' => 'Status',
            ],
            'users_statuses' => [
                'fr' => 'Statut de l\'employé',
                'en' => 'Employee status',
            ],
            'walls' => [
                'fr' => 'Murs de discussion',
                'en' => 'Walls'
            ],
        ])->each(function ($titles, $type) use ($bridge) {
            $bridge->contentTypeUpdateOrCreate(
                type: $type,
                options: [
                   'name' => $type,
                   'title' => $titles,
                   'translatable' => true,
                ]
            );
            $bridge->changeFieldFormOptions($type, 'langcode', true, 'group_advanced_options');
            InsideSchema::setModelOption($type, 'title', $titles);
        });
        Artisan::call('inside:cleanup');
        Artisan::call("models:rebuild");
    }
}
