<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema as InsideSchema;
use Illuminate\Support\Str;

class SetAllContentTypesAsTranslatable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $types = InsideSchema::getContentTypes();

        foreach (InsideSchema::getContentTypes() as $type) {
            if (Str::endsWith($type, '_menus') || in_array($type, ['comments', 'users'])) {
                continue;
            }

            $bridge->updateContentTypeOptions($type, [
                'translatable' => true
            ]);
        }
    }
}
