<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AlterProjectMarketingStatuses extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'projects',
            fieldName: 'marketing_statuses'
        );

        $bridge->contentTypeCreateField(
            type: 'projects',
            fieldName: 'marketing_statuses',
            options: [
                'name' => 'marketing_statuses',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 370,
                'title' => [
                    'fr' => 'Statut de commercialisation',
                    'en' => 'Marketing statuses',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 370,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['marketing_statuses'],
                    'cardinality' => -1,
                ],
            ]
        );
    }
}
