<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Subsidiaries;

class SeedRssFeedData extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        Subsidiaries::all()
            ->pluck('title', 'uuid')
            ->each(static fn (string $title, string $uuid) => $bridge->contentUpdate(
                type: 'subsidiaries',
                data: [
                    'uuid' => $uuid,
                    'rss' => match ($title) {
                        'IDEC SANTE' => 'https://idec-sante.com/category/actualites-flux-grid-info/feed/rssgrid',
                        'IDEC GRAND SUD' => 'https://idec-grandsud.com/category/actualites-flux-grid-info/feed/rssgrid',
                        'Groupe Idec Invest' => 'https://www.groupeidec-invest.com/category/diffusion-flux-groupe-idec/feed/rssgrid',
                        'Groupe IDEC International' => 'https://www.groupeidec.com/actualites-rss.php',
                        'Faubourg Immobilier' => 'https://www.faubourg-immobilier.com/feed/rss.xml',
                        'Cecia' => 'https://www.cecia.fr/category/article-flux-grid-info/feed/',
                        'Idec' => 'https://idec-ingenierie.com/category/actualites-flux-grid-info/feed/rssgrid',
                        'IDEC SPORT' => 'https://www.idecsport.com/category/diffusion-groupe-idec/feed/rssgrid',
                        'Faubourg Promotion' => 'https://www.faubourg-promotion.com/feed/',
                        'Gedouin Ingenierie' => 'https://www.gedouin-ingenierie.com/feed/',
                        'IDEC AGRO & Factory' => 'https://idec-agro.com/category/actualites-flux-grid-info/feed/rssgrid',
                        default => ''
                    }
                ]
            ));
    }
}
