<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddRssLinkToSubsidiariesContentType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'subsidiaries',
            'rss',
            [
                'name' => 'rss',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Flux RSS',
                    'en' => 'RSS Feed',
                ],
                'widget'      => [
                    'type'     => BridgeContentType::TEXT_WIDGET,
                    'settings' => [],
                    'weight' => 10,
                ],
                'type'        => BridgeContentType::TEXT_FIELD,
                'settings'    => [
                    'max_length'     => 255,
                    'is_ascii'       => false,
                    'case_sensitive' => false,
                    'cardinality'    => 1,
                ],
            ],
        );
    }
}
