<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\MoveHours;

class CarpoolsDeleteFieldsImageAndContent extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'carpools', 'image');
        $bridge->contentTypeDeleteField('node', 'carpools', 'content');
        $bridge->changeFieldTitle(
            'carpools',
            'introduction',
            [
                'fr' => 'Description',
                'en' => 'Description',
            ]
        );
        $bridge->changeFieldTitle(
            'carpools',
            'move_hours',
            [
                'fr' => 'Heure de départ',
                'en' => 'Departure time',
            ]
        );

        $bridgeContent = new BridgeContent();
        MoveHours::query()
            ->get()
            ->each(function ($moveHour) use ($bridgeContent) {
                $bridgeContent->contentDelete($moveHour->content_type, $moveHour->uuid);
            });

        $defaultLangcode = env('APP_LOCALE');
        $languages = list_languages();
        foreach (range(0, 23) as $hour) {
            foreach (range(0, 45, 15) as $minute) {
                $quartersOfHours = sprintf('%02dh%02d', $hour, $minute);

                $uuid = $bridgeContent->contentInsert('move_hours', [
                    'status' => 1,
                    'langcode' => 'fr',
                    'title' => $quartersOfHours,
                ]);

                $baseHour = MoveHours::find($uuid);

                foreach ($languages as $langcode) {
                    if ($langcode === $defaultLangcode) {
                        continue;
                    }

                    $bridgeContent->contentInsert('move_hours', [
                        'status' => 1,
                        'langcode' => $langcode,
                        'title' => $quartersOfHours,
                        'uuid_host' => $baseHour->uuid_host,
                    ]);
                }
            }
        }
    }
}
