<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProjectsStatusField extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'projects', 'statuses');
        $bridge->contentTypeDeleteField('node', 'projects', 'projects_statuses');
        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'projects_statuses',
            [
                'name' => 'projects_statuses',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 7,
                'filter_category' => '',
                'weight' => 340,
                'title' => [
                    'fr' => 'Statut du projet',
                    'en' => 'Project statuses',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 340,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['projects_statuses'],
                    'cardinality' => 1,
                ],
            ],
            430
        );
    }

    public function down(): void
    {
    }
}
