<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class UpdateDistanceAndRoundTimeField extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'distance_and_round_time',
            [
                'name' => 'distance_and_round_time',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 570,
                'title' => [
                    'fr' => 'Distance et temps de parcours',
                    'en' => 'Distance and round time',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 53,
                    'group' => 'group_faubourg_immobilier'
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        );
    }

    public function down(): void
    {
    }
}
