<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateSubsidiariesContentType extends Migration
{
    /**
     * @return void
     * @throws \Drupal\Core\Entity\EntityStorageException
     * @throws \Inside\Host\Exceptions\ColumnAlreadyExistsException
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'subsidiaries',
            'subsidiaries_logo',
            [
                'name' => 'subsidiaries_logo',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Logo',
                    'en' => 'Logo',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
        );

        $bridge->contentTypeCreateOrUpdateField(
            'subsidiaries',
            'subsidiaries_website',
            [
                'name' => 'subsidiaries_website',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Site Internet',
                    'en' => 'Website',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
