<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProjectsTypeAndUsers extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->changeFieldTitle(
            'projects',
            'available_area',
            [
                'fr' => 'Surface disponible (en m2)',
                'en' => 'Available area (en m2)',
            ]
        );

        $bridge->changeFieldTitle(
            'projects',
            'building_floor_area_fi',
            [
                'fr' => 'Surface constructible de plancher (en m2)',
                'en' => 'Buildable floor area (en m2)',
            ]
        );

        $bridge->changeFieldTitle(
            'projects',
            'commercial_area',
            [
                'fr' => 'Surface commerciale (en m2)',
                'en' => 'Commercial area (en m2)',
            ]
        );

        $bridge->changeFieldTitle(
            'projects',
            'land_area',
            [
                'fr' => 'Surface foncier (en m2)',
                'en' => 'Land area (en m2)',
            ]
        );

        $bridge->contentTypeCreateOrUpdateField('projects', 'project_amount', [
            'name' => 'project_amount',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 200,
            'title' => [
                'fr' => 'Montant du projet (en €)',
                'en' => 'Project amount (in €)',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 200,
                'group' => 'group_idec_ingenierie',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('projects', 'built_area', [
            'name' => 'built_area',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 210,
            'title' => [
                'fr' => 'Surface construite (en m2)',
                'en' => 'Built area (in m2)',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 210,
                'group' => 'group_idec_ingenierie',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('projects', 'building_types', [
            'name' => 'building_types',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 50,
            'searchable_filter' => true,
            'filter_widget' => 'selectmulti',
            'filter_order' => 2,
            'filter_category' => '',
            'title' => [
                'fr' => 'Typologie de bâtiment',
                'en' => 'Building type',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 50,
                'group' => 'group_common_fields',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['building_types'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);

        $bridge->contentTypeCreateOrUpdateField('projects', 'news', [
            'name' => 'news',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Actualités internes',
                'en' => 'Internal news',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);

        $bridge->contentTypeCreateOrUpdateField('projects', 'project_news', [
            'name' => 'project_news',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Actualités projet (issues des flux RSS)',
                'en' => 'Project news (from RSS feeds)',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['project_news'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);

        $this->bootUp(__FILE__);
        $this->migrateContent('services');
        $this->finishUp();

        $bridge->contentTypeDeleteField('user', 'user', 'departments');
        $bridge->contentTypeCreateOrUpdateField('users', 'services', [
            'name' => 'services',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'Service',
                'en' => 'Service',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 12,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['services'],
                'cardinality' => 1,
            ],
        ]);
    }
}
