<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Users;
use Inside\Support\Str;

class RemoveUselessUsers extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $bridge = new BridgeContent();

        Users::each(function ($user) use ($bridge) {
            if (empty($user->firstname) || empty($user->lastname) ||
               substr(trim($user->mail), 0, 3) === "EXT" ||
               substr(trim($user->mail), 0, -3) === "EXT" ||
               $user->subsidiaries->isEmpty()
            ) {
                if (!Str::contains($user->email, 'maecia') && !Str::contains($user->email, 'intranet-inside')) {
                    $this->writeln('deleting user ' . $user->email . ' ...');
                    $bridge->contentDelete('users', $user->uuid);
                }
            }
        });
    }

    public function down(): void
    {
    }
}
