<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProjectsFilters extends Migration
{
    /**
     * @return void
     * @throws \Drupal\Core\Entity\EntityStorageException
     * @throws \Inside\Host\Exceptions\ColumnAlreadyExistsException
     */
    public function up()
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'certificates_ing',
            [
            'name' => 'certificates_ing',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'filter_widget' => 'checkboxesgroup',
            'filter_order' => 8,
            'filter_category' => '',
            'weight' => 260,
            'title' => [
                'fr' => 'Certifications',
                'en' => 'Certificates',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 260,
                'group' => 'group_idec_ingenierie',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['certificates_ing'],
                'cardinality' => 1,
            ],
        ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'industries',
            [
            'name' => 'industries',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 40,
            'filter_widget' => 'selectmulti',
            'filter_order' => 3,
            'filter_category' => '',
            'title' => [
                'fr' => 'Secteur',
                'en' => 'Sector',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 40,
                'group' => 'group_common_fields',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['industries'],
                'cardinality' => 1,
            ],
        ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'departments',
            [
            'name' => 'departments',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 80,
            'filter_widget' => 'selectmulti',
            'filter_order' => 4,
            'filter_category' => '',
            'searchable_filter' => true,
            'title' => [
                'fr' => 'Localisation',
                'en' => 'Location',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 80,
                'group' => 'group_common_fields',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['departments'],
                'cardinality' => 1,
            ],
        ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'projects_statuses',
            [
                'name' => 'projects_statuses',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 340,
                'title' => [
                    'fr' => 'Etat du projet',
                    'en' => 'Project statuses',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 340,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['projects_statuses'],
                    'cardinality' => 1,
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'subsidiaries',
            [
            'name' => 'subsidiaries',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'searchable_filter' => true,
            'filter_widget' => 'selectmulti',
            'filter_order' => 1,
            'filter_category' => '',
            'weight' => 30,
            'title' => [
                'fr' => 'Filiale',
                'en' => 'Subsidiary',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 30,
                'group' => 'group_common_fields',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['subsidiaries'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]
        );
    }
}
