<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class CreateUsersFieldsForImport extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $this->bootUp(__FILE__);

        $this->migrateContent('legal_entities');
        $this->migrateContent('users_statuses');
        $this->migrateContent('contracts_types');

        $this->finishUp();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'legal_entities',
            [
                'name' => 'legal_entities',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Société juridique et d\'appartenance',
                    'en' => 'Legal entity and membership',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => []
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['legal_entities'],
                    'cardinality' => 1,
                ],
            ],
            11
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'users_statuses',
            [
                'name' => 'users_statuses',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Statut de l\'employé',
                    'en' => 'Employee status',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => []
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['users_statuses'],
                    'cardinality' => 1,
                ],
            ],
            12
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'contracts_types',
            [
                'name' => 'contracts_types',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 13,
                'title' => [
                    'fr' => 'Type de contrat',
                    'en' => 'Contracts type',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => []
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['contracts_types'],
                    'cardinality' => 1,
                ],
            ],
            13
        );

        $types = ['CDI', 'CDD', 'Alternance', 'Stage'];
        $bridgeContent = new BridgeContent();
        foreach ($types as $type) {
            $bridgeContent->contentInsert('contracts_types', [
                'type' => 'node',
                'bundle' => 'contracts_types',
                'title' => $type
            ]);
        }
    }

    public function down(): void
    {
    }
}
