<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class CreateContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('blocks');
        $this->migrateContent('divisions');
        $this->migrateContent('marketing_statuses');
        $this->migrateContent('energy_approaches');
        $this->migrateContent('pinel_areas');
        $this->migrateContent('ptz_areas');
        $this->migrateContent('project_types_ing');
        $this->migrateContent('project_types_fp');
        $this->migrateContent('building_function');
        $this->migrateContent('tax_benefits');
        $this->migrateContent('professions');
        $this->migrateContent('delivery_years');
        $this->migrateContent('regions');
        $this->migrateContent('cities');
        $this->migrateContent('building_types');
        $this->migrateContent('industries');
        $this->migrateContent('certificates_ing');
        $this->migrateContent('certificates_fp');
        $this->migrateContent('certificates_fi');
        $this->migrateContent('progress_projects');
        $this->migrateContent('move_hours');
        $this->migrateContent('carpools');
        $this->migrateContent('custom');
        $this->migrateContent('departments');
        $this->migrateContent('folders');
        $this->migrateContent('dms_link');
        $this->migrateContent('documents');
        $this->migrateContent('subsidiaries');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('locations');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('pages');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('spaces');
        $this->migrateContent('pages_categories');
        $this->migrateContent('spaces_pages');
        $this->migrateContent('projects_locations');
        $this->migrateContent('projects_statuses');
        $this->migrateContent('commercial_firms');
        $this->migrateContent('construction_quarters');
        $this->migrateContent('delivery_date_quarters');
        $this->migrateContent('statuses');
        $this->migrateContent('projects');
        $this->migrateContent('users');
        $this->migrateContent('project_folders');
        $this->migrateContent('project_documents');

        $this->finishUp();

        $defaultTitles = ['T1', 'T2', 'T3', 'T4'];
        $this->createDefaultContents('construction_quarters', $defaultTitles);
        $this->createDefaultContents('delivery_date_quarters', $defaultTitles);
    }

    /**
     * @param string $contentType
     * @param array $titles
     * @return void
     * @throws Exception
     */
    private function createDefaultContents(string $contentType, array $titles)
    {
        $bridgeContent = new BridgeContent();

        foreach ($titles as $title) {
            $entity = call_user_func(type_to_class($contentType) . '::query')
                ->where('title', $title)->first();
            if ($entity) {
                return;
            }

            $bridgeContent->contentInsert('construction_quarters', [
                'type' => 'node',
                'bundle' => $contentType,
                'title' => $title
            ]);
        }
    }
}
