<?php

declare(strict_types=1);

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'projects',
    ],
    'fields' => [
        [
            'name' => 'construction_year',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Année de début de chantier',
                'en' => 'Year construction start',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'group' => 'group_common_fields',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'construction_month',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Mois de début de chantier',
                'en' => 'Month construction start',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'group' => 'group_common_fields',
            ],
            'type' => BridgeContentType::LIST_STRING_FIELD,
            'settings' => [
                'cardinality' => 1,
                'allowed_values' => [
                    '01' => [
                        'fr' => '01 - Janvier',
                        'en' => '01 - January',
                    ],
                    '02' => [
                        'fr' => '02 - Fevrier',
                        'en' => '02 - February',
                    ],
                    '03' => [
                        'fr' => '03 - Mars',
                        'en' => '03 - March',
                    ],
                    '04' => [
                        'fr' => '04 - Avril',
                        'en' => '04 - April',
                    ],
                    '05' => [
                        'fr' => '05 - Mai',
                        'en' => '05 - May',
                    ],
                    '06' => [
                        'fr' => '06 - Juin',
                        'en' => '06 - June',
                    ],
                    '07' => [
                        'fr' => '07 - Juillet',
                        'en' => '07 - July',
                    ],
                    '08' => [
                        'fr' => '08 - Août',
                        'en' => '08 - August',
                    ],
                    '09' => [
                        'fr' => '09 - Septembre',
                        'en' => '09 - September',
                    ],
                    '10' => [
                        'fr' => '10 - Octobre',
                        'en' => '10 - October',
                    ],
                    '11' => [
                        'fr' => '11 - Novembre',
                        'en' => '11 - November',
                    ],
                    '12' => [
                        'fr' => '12 - Décembre',
                        'en' => '12 - December',
                    ],
                ],
            ],
        ],
        [
            'name' => 'construction_quarters',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Trimestre debut de chantier',
                'en' => 'Quarter start of construction',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'group' => 'group_common_fields',
            ],
            'type' => BridgeContentType::LIST_STRING_FIELD,
            'settings' => [
                'cardinality' => 1,
                'allowed_values' => [
                    'T1' => [
                        'fr' => 'Trimestre 1',
                        'en' => 'Quarter 1',
                    ],
                    'T2' => [
                        'fr' => 'Trimestre 2',
                        'en' => 'Quarter 2',
                    ],
                    'T3' => [
                        'fr' => 'Trimestre 3',
                        'en' => 'Quarter 3',
                    ],
                    'T4' => [
                        'fr' => 'Trimestre 4',
                        'en' => 'Quarter 4',
                    ],
                ],
            ],
        ],
    ],
];
