<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'projects',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Projet',
            'en' => 'Project',
        ],
    ],
    'fields' => [
            [
                'name' => 'banner',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'news',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Actualité',
                    'en' => 'News',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['news'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'project_teams',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Equipe de projet',
                    'en' => 'Project team',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => -1,
                ],
            ],
            [
                'name' => 'projects',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Projets liés',
                    'en' => 'Related projects',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['projects'],
                    'cardinality' => -1,
                ],
            ],
            [
                'name' => 'main_image',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Image principale du projet',
                    'en' => 'Project main image',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'project_description',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Descriptif du projet',
                    'en' => 'Project description',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                    'weight' => 10,
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'statuses',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 7,
                'filter_category' => '',
                'weight' => 15,
                'title' => [
                    'fr' => 'Statut',
                    'en' => 'Statuses',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 15
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['statuses'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'geolocation',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 16,
                'title' => [
                    'fr' => 'Géolocalisation',
                    'en' => 'Geolocation',
                ],
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraphe',
                        'title_plural' => 'Paragraphes',
                        'edit_mode' => 'open',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '',
                    ],
                    'weight' => 16,
                ],
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => ['map'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'medias',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 160,
                'title' => [
                    'fr' => 'Médias',
                    'en' => 'Medias',
                ],
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraphe',
                        'title_plural' => 'Paragraphes',
                        'edit_mode' => 'open',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '',
                    ],
                    'weight' => 160,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => ['image', 'video'],
                    'cardinality' => -1,
                ],
            ],
            [
                'name' => 'professions',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 20,
                'title' => [
                    'fr' => 'Métier',
                    'en' => 'Professions',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 20,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['professions'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'subsidiaries',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'required' => true,
                'searchable_filter' => true,
                'filter_widget' => 'selectmulti',
                'filter_order' => 1,
                'filter_category' => '',
                'weight' => 30,
                'title' => [
                    'fr' => 'Filiale',
                    'en' => 'Subsidiary',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 30,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['subsidiaries'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'industries',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 40,
                'title' => [
                    'fr' => 'Secteur',
                    'en' => 'Sector',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 40,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['industries'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'building_types',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'weight' => 50,
                'searchable_filter' => true,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 2,
                'filter_category' => '',
                'title' => [
                    'fr' => 'Typologie bâtiment',
                    'en' => 'Building type',
                ],
                'widget' => [
                    'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                    'settings' => [],
                    'weight' => 50,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['building_types'],
                    'cardinality' => -1,
                ],
            ],
            [
                'name' => 'address',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 60,
                'title' => [
                    'fr' => 'Adresse',
                    'en' => 'Address',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 60,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'cities',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 70,
                'title' => [
                    'fr' => 'Ville',
                    'en' => 'Cities',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 70,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['cities'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'departments',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'weight' => 80,
                'filter_widget' => 'selectmulti',
                'filter_order' => 4,
                'filter_category' => '',
                'searchable_filter' => true,
                'title' => [
                    'fr' => 'Département',
                    'en' => 'Departments',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 80,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['departments'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'country',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 90,
                'title' => [
                    'fr' => 'Pays',
                    'en' => 'Country',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 90,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'communicable_reference',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 110,
                'title' => [
                    'fr' => 'Référence communicable',
                    'en' => 'Communicable reference',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 110,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            [
                'name' => 'construction_start',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 120,
                'title' => [
                    'fr' => 'Début chantier',
                    'en' => 'Construction start',
                ],
                'widget' => [
                    'type' => BridgeContentType::TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight' => 120,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'construction_quarters',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 121,
                'title' => [
                    'fr' => 'Trimestre debut de chantier',
                    'en' => 'Quarter start of construction',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 121,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['construction_quarters'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'delivery_date',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 130,
                'title' => [
                    'fr' => 'Date de livraison',
                    'en' => 'Delivery date',
                ],
                'widget' => [
                    'type' => BridgeContentType::TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight' => 130,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'delivery_date_quarters',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 131,
                'title' => [
                    'fr' => 'Trimestre date de livraison',
                    'en' => 'Delivery date quarter',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 131,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['delivery_date_quarters'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'work_duration',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 140,
                'title' => [
                    'fr' => 'Durée travaux',
                    'en' => 'Work duration',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 140,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'architect',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 170,
                'title' => [
                    'fr' => 'Architecte',
                    'en' => 'Architect',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 170,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'customer_testimonial',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 180,
                'title' => [
                    'fr' => 'Témoignages client',
                    'en' => 'Customers testimonial',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                    'weight' => 180,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'energy_approaches',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 190,
                'title' => [
                    'fr' => 'Approche énergétique',
                    'en' => 'Energy approaches',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 190,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['energy_approaches'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'project_amount',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 200,
                'title' => [
                    'fr' => 'Montant du projet',
                    'en' => 'Project amount',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 200,
                    'group' => 'group_idec_ingenierie',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'built_area',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 210,
                'title' => [
                    'fr' => 'Surface construite',
                    'en' => 'Built area',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 210,
                    'group' => 'group_idec_ingenierie',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'project_types_ing',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 220,
                'title' => [
                    'fr' => 'Nature du projet ING',
                    'en' => 'Project types ING',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 220,
                    'group' => 'group_idec_ingenierie',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['project_types_ing'],
                    'cardinality' => -1,
                ],
            ],
            [
                'name' => 'building_function',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 230,
                'title' => [
                    'fr' => 'Fonction du bâtiment',
                    'en' => 'Building function',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 230,
                    'group' => 'group_idec_ingenierie',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['building_function'],
                    'cardinality' => -1,
                ],
            ],
            [
                'name' => 'issues',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 240,
                'title' => [
                    'fr' => 'Enjeux',
                    'en' => 'Issues',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [],
                    'weight' => 240,
                    'group' => 'group_idec_ingenierie',
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'our_answer',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 250,
                'title' => [
                    'fr' => 'Réponse',
                    'en' => 'Our Answer',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [],
                    'weight' => 250,
                    'group' => 'group_idec_ingenierie',
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'certificates_ing',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 8,
                'filter_category' => '',
                'weight' => 260,
                'title' => [
                    'fr' => 'Certifications ING',
                    'en' => 'ING Certificates',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 260,
                    'group' => 'group_idec_ingenierie',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['certificates_ing'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'project_types_fp',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 270,
                'title' => [
                    'fr' => 'Nature du projet FP',
                    'en' => 'Project types FP',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 270,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['project_types_fp'],
                    'cardinality' => -1,
                ],
            ],

            [
                'name' => 'user',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 290,
                'title' => [
                    'fr' => 'Utilisateur(s)',
                    'en' => 'User',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 290,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'planner_fp',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 300,
                'title' => [
                    'fr' => 'Aménageur',
                    'en' => 'Planner',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 300,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'investor',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 310,
                'title' => [
                    'fr' => 'Investisseur',
                    'en' => 'Investor',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 310,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'co_promoter_fp',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 320,
                'title' => [
                    'fr' => 'Co promoteur',
                    'en' => 'Co promoteur',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 320,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'builder_fp',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 330,
                'title' => [
                    'fr' => 'Constructeur',
                    'en' => 'Builder',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 330,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'projects_statuses',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 7,
                'filter_category' => '',
                'weight' => 340,
                'title' => [
                    'fr' => 'Etat du projet',
                    'en' => 'Project statuses',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 340,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['projects_statuses'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'benefits_and_user_comfort',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 350,
                'title' => [
                    'fr' => 'Prestations et confort d\'usage',
                    'en' => 'Benefits and user comfort',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 350,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'technical_description',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 360,
                'title' => [
                    'fr' => 'Descriptif technique',
                    'en' => 'Technical description',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 360,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'marketing_statuses',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 370,
                'title' => [
                    'fr' => 'Statut de commercialisation',
                    'en' => 'Marketing statuses',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 370,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['marketing_statuses'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'available_area',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 380,
                'title' => [
                    'fr' => 'Surface disponible',
                    'en' => 'Available area',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 380,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'building_floor_area_fp',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 390,
                'title' => [
                    'fr' => 'Surface constructible de plancher',
                    'en' => 'Buildable floor area',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 390,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'land_area',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 400,
                'title' => [
                    'fr' => 'Surface foncier',
                    'en' => 'Land area',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 400,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'number_of_created_jobs',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 410,
                'title' => [
                    'fr' => 'Nombre d\'emplois créés',
                    'en' => 'Number of created jobs',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 410,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'number_of_lots_fp',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 420,
                'title' => [
                    'fr' => 'Nombre de lots',
                    'en' => 'Number of lots',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 420,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'leasing_user',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 421,
                'title' => [
                    'fr' => 'Mise à bail - Utilisateur',
                    'en' => 'Leasing user',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 421,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'leasing_date',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 422,
                'title' => [
                    'fr' => 'Date du mise à bail',
                    'en' => 'Lease date',
                ],
                'widget' => [
                    'type' => BridgeContentType::TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight' => 422,
                    'group' => 'group_common_fields',
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'leasing_duration',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 423,
                'title' => [
                    'fr' => 'Durée du bail en années',
                    'en' => 'Duration of the lease in years',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 423,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'accesses',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 445,
                'title' => [
                    'fr' => 'Les accès',
                    'en' => 'The accesses',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [],
                    'weight' => 445,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'certificates_fp',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 8,
                'filter_category' => '',
                'weight' => 450,
                'title' => [
                    'fr' => 'Certifications FP',
                    'en' => 'FP Certificates',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 450,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['certificates_fp'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'divisible',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 451,
                'title' => [
                    'fr' => 'Divisible',
                    'en' => 'Divisible',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 451,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            [
                'name' => 'divisible_from',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 452,
                'title' => [
                    'fr' => 'Divisible à partir de',
                    'en' => 'Divisible from',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 452,
                    'group' => 'group_faubourg_promotion',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'co_promoter_fi',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 460,
                'title' => [
                    'fr' => 'Co promoteur',
                    'en' => 'Co promoteur',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 460,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'planner_fi',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 470,
                'title' => [
                    'fr' => 'Aménageur',
                    'en' => 'Planner',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 470,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'builder_fi',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 480,
                'title' => [
                    'fr' => 'Constructeur',
                    'en' => 'Builder',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 480,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'progress_projects',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 490,
                'title' => [
                    'fr' => 'Avancement du projet',
                    'en' => 'Progress of projects',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 490,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['progress_projects'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'building_floor_area_fi',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 500,
                'title' => [
                    'fr' => 'Surface constructible de plancher',
                    'en' => 'Buildable floor area',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 500,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'commercial_area',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 510,
                'title' => [
                    'fr' => 'Surface commerciale',
                    'en' => 'Commercial area',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 510,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'number_of_lots_fi',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 520,
                'title' => [
                    'fr' => 'Nombre de lots',
                    'en' => 'Number of lots',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 520,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'tax_benefits',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 530,
                'title' => [
                    'fr' => 'Avantages fiscaux',
                    'en' => 'Tax benefits',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 530,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['tax_benefits'],
                    'cardinality' => -1,
                ],
            ],
            [
                'name' => 'pinel_areas',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 540,
                'title' => [
                    'fr' => 'Zone PINEL',
                    'en' => 'PINEL areas',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 540,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['pinel_areas'],
                    'cardinality' => 1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'ptz_areas',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 550,
                'title' => [
                    'fr' => 'Zone PTZ',
                    'en' => 'PTZ areas',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 550,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['ptz_areas'],
                    'cardinality' => 1,
                ],
                'selectable_all' => true,
            ],
            [
                'name' => 'hook',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 560,
                'title' => [
                    'fr' => 'Accroche',
                    'en' => 'Hook',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 560,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'distance_and_round_time',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 570,
                'title' => [
                    'fr' => 'Distance et temps de parcours',
                    'en' => 'Distance and round time',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 53,
                    'group' => 'group_faubourg_immobilier'
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'benefits',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 580,
                'title' => [
                    'fr' => 'Prestations',
                    'en' => 'Benefits',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 580,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'certificates_fi',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 8,
                'filter_category' => '',
                'weight' => 590,
                'title' => [
                    'fr' => 'Certifications FI',
                    'en' => 'FI Certificates',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 590,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['certificates_fi'],
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'commercial_firms',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'filter_widget' => 'checkboxesgroup',
                'filter_order' => 8,
                'filter_category' => '',
                'weight' => 591,
                'title' => [
                    'fr' => 'Bureau de vente',
                    'en' => 'Commercial firms',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 591,
                    'group' => 'group_faubourg_immobilier',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['commercial_firms'],
                    'cardinality' => -1,
                ],
            ],
        ],
    ];
