<?php

use Illuminate\Database\Eloquent\Builder;
use Laravel\Lumen\Http\Request;

function buildRelationSearchQuery(Builder $query, Request $request, string $parameter, string $fieldName): Builder
{
    if (! $request->has($parameter)) {
        return $query;
    }

    return $query->whereHas(
        $fieldName,
        fn ($sub) => is_array($request->get($parameter))
        ? $sub->whereIn('uuid', $request->get($parameter))
        : $sub->where('uuid', $request->get($parameter))
    );
}

return [
    'inside_external_api_enabled' => env('INSIDE_EXTERNAL_API_ENABLED', false),
    'inside_external_api_bypass_auth_external' => env('INSIDE_EXTERNAL_API_AUTH_BYPASS', true),
    'inside_external_api_fields' => [
        'projects' => [
            'uuid',
            'title',
            'updated_at',
            'news' => [
                'uuid',
                'title',
            ],
            'project_news' => [
                'uuid',
                'title',
            ],
            'energy_approaches' => [
                'uuid',
                'title',
            ],
            'progress_projects' => [
                'uuid',
                'title',
            ],
            'tax_benefits' => [
                'uuid',
                'title',
            ],
            'certificates' => [
                'uuid',
                'title',
            ],
            'commercial_firms' => [
                'uuid',
                'title',
            ],
            'project_teams' => [
                'uuid',
                'title',
            ],
            'subsidiaries' => [
                'uuid',
                'title',
            ],
            'building_function' => [
                'uuid',
                'title',
            ],
            'departments' => [
                'uuid',
                'title',
            ],
            'professions' => [
                'uuid',
                'title',
            ],
            'project_types_fp' => [
                'uuid',
                'title',
            ],
            'project_types_ing' => [
                'uuid',
                'title',
            ],
            'projects' => [
                'uuid',
                'title',
            ],
            'communicable_reference' => [
                'uuid',
                'title',
            ],
            'industries' => [
                'uuid',
                'title',
            ],
            'marketing_statuses' => [
                'uuid',
                'title',
            ],
            'projects_statuses' => [
                'uuid',
                'title',
            ],
            'construction_quarters' => [
                'uuid',
                'title',
            ],
            'building_types' => [
                'uuid',
                'title',
            ],
            'cities' => [
                'uuid',
                'title',
            ],
            'pinel_areas' => [
                'uuid',
                'title',
            ],
            'ptz_areas' => [
                'uuid',
                'title',
            ],
        ],
        'departments' => [
            'uuid',
            'title',
            'code',
        ],
        'progress_projects' => [
            'uuid',
            'title',
        ],
        'building_types' => [
            'uuid',
            'title',
        ],
    'tax_benefits' => [
        'uuid',
        'title',
    ],
        'pinel_areas' => [
            'uuid',
            'title',
        ],
        'ptz_areas' => [
            'uuid',
            'title',
        ],
        'subsidiaries' => [
            'title',
            'uuid'
        ],
        'project_types_ing' => [
            'title',
            'uuid'
        ],
        'projects_statuses' => [
            'title',
            'uuid'
        ],
        'industries' => [
            'title',
            'uuid'
        ],
        'certificates' => [
            'title',
            'uuid'
        ],
    ],
    'inside_external_api_filters' => function ($query, $request) {
        $query = buildRelationSearchQuery($query, $request, 'subsidiaries', 'subsidiaries');
        $query = buildRelationSearchQuery($query, $request, 'departments', 'departments');
        $query = buildRelationSearchQuery($query, $request, 'natures', 'project_types_ing');
        $query = buildRelationSearchQuery($query, $request, 'projects_statuses', 'projects_statuses');
        $query = buildRelationSearchQuery($query, $request, 'industries', 'industries');
        $query = buildRelationSearchQuery($query, $request, 'certificates', 'certificates');

        if ($request->has('langcode')) {
            $query->where('langcode', $request->get('langcode'));
        }
        $query->where('status', 1);
        return $query;
    }
];
