<?php

use Inside\Content\Models\Contents\Department;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Users;

return [
    'postfilter' => fn ($users) => $users
        ->reject(function ($user) {
            return (
                !$user->accountEnabled ||
                $user->mail === null ||
                substr(trim($user->mail), 0, 3) === "EXT" ||
                substr(trim($user->mail), 0, -3) === "EXT" ||
                $user->givenName === null ||
                $user->surname === null ||
                $user->companyName === null ||
                $user->userType !== 'Member'
            );
        }),
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'image' => true,
        'langcode' => fn () => 'fr',
        'status' => fn () => 1,
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'subsidiaries' => fn ($user) => $user->onPremisesExtensionAttributes->extensionAttribute15 ? reference('subsidiaries')->from(str($user->onPremisesExtensionAttributes->extensionAttribute15)->lower()->ucfirst()->toString())->get() : null,
        'services' => fn ($user) => reference('services')->from($user->department)->get(),
        'locations' => fn ($user) => reference('locations')->from($user->officeLocation)->get(),
        'phone' => fn ($user) => implode(", ", $user->businessPhones),
        'mobile_phone' => 'mobilePhone',
        'office_location' => 'officeLocation',
        'address' => 'streetAddress',
        'teams' => 'userPrincipalName',
        'cities' => fn ($user) => reference('cities')->from($user->city)->get(),
        'users' => fn ($user) => reference('users')->identifiedBy('email')->from($user->manager)->withoutCreation()->first(),
        'function' => fn ($user) => $user->jobTitle ? str($user->jobTitle)->upper() : null,
        'legal_entities' => fn ($user) => reference('legal_entities')->from($user->companyName)->get(),
        'users_statuses' => fn ($user) => $user->onPremisesExtensionAttributes->extensionAttribute2 ? reference('users_statuses')->from(str($user->onPremisesExtensionAttributes->extensionAttribute2)->lower()->ucfirst()->toString())->get() : null,
    ],
    'custom_attributes' => [
        'manager' => 'mail'
    ]
];
