import TabSpacePage from '../pages/spaces/TabSpacePage'

import { fetchTabSpacesPage } from '../components/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'TabSpacePage',
    path: '/espaces/:slug',
    meta: { content: 'spaces' },
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchTabSpacesPage
    )
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'FormPage',
    meta: { disabled: true }
  }
]
