import { http } from '@inside-library/helpers/Http'

export const fetchTabSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'admin',
        'content_type',
        'published_at'
      ],
      filters: { 'status:eq': 1, 'slug:eq': $route.params.slug }
    })
    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
