<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateUsersSendMailFieldDefaultValue extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField('users', 'send_mail', [
            'default' => true,
        ]);
        $this->finishUp();
    }
}
