<?php

return [
    'files' => [
        'ifvd' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ';'),
            'fields' => [
                'email' => 'email',
                'name' => 'email',
                'firstname' => 'firstname',
                'lastname' => 'lastname',
                'phone' => 'telephone_extranet',
                'function' => 'structure_position_names',
                'website' => function (array $record) {
                    $email = str($record['site_internet1'] ?? '')->trim();

                    return match (true) {
                        $email->isEmpty() => null,
                        ! $email->startsWith('https://') && ! $email->startsWith('http://') => $email->start('http://')->toString(),
                        default => $email->toString()
                    };
                },
                'company_name' => 'structures',
                'emailing_listings' => fn (array $record) => str($record['emailing_lists'] ?? '')
                    ->explode(',')
                    ->filter()
                    ->map(fn (string $listing) => reference('emailing_listings')->identifiedBy('code')->from(trim($listing))->get())
                    ->flatten()
                    ->filter()
                    ->unique()
                    ->values()
                    ->all(),
                'types' => fn (array $record) => reference('types')->identifiedBy('code')->from($record['type_de_structure'])->get(),
                'branches' => fn (array $record) => reference('branches')->identifiedBy('code')->from($record['branche1'])->get(),
                'expertises' => fn (array $record) => collect($record)
                    ->only("domaine_dactivite1", "domaine_dactivite2")
                    ->filter()
                    ->map(fn ($value) => reference('expertises')->identifiedBy('code')->from($value)->get())
                    ->flatten()
                    ->filter()
                    ->unique()
                    ->values()
                    ->all(),
                'status' => fn () => true,
                'is_maintenance' => fn () => false,
            ],
        ],
    ],
];
