<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => false,
        'logoUrl'   => 'vendor/maecia/ifvd-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 40
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/ifvd-back/resources/assets/img/newsletter/bg.png',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'showGreetings' => false,
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'sorts' => ['published_at:desc'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#D40C72',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#D40C72',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#D40C72',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#D40C72'
            ],
        ],
        'activities' => [
            'link'        => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2c3f50',
            'items' => [
                'likes' => [
                    'callback' => function () {
                        return \Inside\Reaction\Models\Reaction::where('type', 'like')->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/ifvd-back/resources/assets/img/newsletter/like.png',
                    'titleStrKey' => 'newsletter.likes_statistic',
                ],
                'users' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\Users::where('status', true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/ifvd-back/resources/assets/img/newsletter/user.png',
                    'titleStrKey' => 'newsletter.users_statistic',
                ],
                'news' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\News::where('status', true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/ifvd-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey' => 'newsletter.contents_statistic',
                ],
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#1D2A36',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/F%C3%A9d%C3%A9ration-de-la-Vente-Directe-1376091345984309/',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/fvd_officiel',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/f%C3%A9d%C3%A9ration-de-la-vente-directe/',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/federation_de_la_vente_directe/',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
