<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddedDefaultTools extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('users', false);
        $this->finishUp();

        $tools = Tools::all()->sortBy(fn (Tools $product) => match ($product->title) {
            'Ressources' => 1,
            'Annuaire' => 2,
            'Agenda' => 3,
            default => 4
        });

        $bridgeContent = new BridgeContent();
        $bridgeContentType = new BridgeContentType();
        Users::each(function (Users $user) use ($bridgeContent, $tools) {
            $bridgeContent->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $tools->pluck('uuid')->all(),
            ]);
        });

        $bridgeContentType->contentTypeCreateOrUpdateField('users', 'tools', [
            'default' => $tools->pluck('uuid_host')->map(fn (string $uuid) => ['target_uuid' => $uuid])->all(),
        ]);
    }
}
