import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'

import { withFetch } from 'inside-collection/hocs'

import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/fetch'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false },
    component: () => import('../pages/events/EventsCalendarPage')
  },
  {
    name: 'EventPage',
    meta: { disabled: false },
    props: {
      extraFields: [{ regional_directions: ['uuid', 'title'] }],
      contentOptions: {
        categoriesConfig: {
          events_categories: {
            data: (data, contentType, { getData }) => {
              return getData(data, contentType)
            },
            disabledOn: ['EventsCalendarPage'],
            href: item => ({
              name: 'EventsCalendarPage',
              query: { events_categories: item.uuid }
            })
          },
          regional_directions: {
            data: (data, contentType, { getData }) => {
              return getData(data, contentType)
            },
            disabledOn: ['EventsCalendarPage'],
            href: data => ({
              name: 'EventsCalendarPage',
              query: { regional_directions: data.uuid }
            })
          }
        }
      }
    }
  },
  {
    name: 'NewsCategoriesListingPage',
    meta: { disabled: false },
    props: {
      authorFields: []
    }
  },
  {
    name: 'NewsCategoriesPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    props: {
      extraFields: [{ regional_directions: ['uuid', 'title'] }],
      contentOptions: {
        extraCategoriesFields: [{ regional_directions: ['uuid', 'title'] }],
        extraCategoriesConfig: {
          regional_directions: {
            data: (data, contentType, { getData }) => {
              return getData(data, contentType)
            },
            disabledOn: ['NewsListingPage', 'NewsCategoriesListingPage'],
            href: data => ({
              name: 'NewsListingPage',
              query: { regional_directions: data.uuid }
            })
          }
        }
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'FormPage',
    meta: { disabled: true }
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/pages/:slug',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  }
]
