import Google from '@inside-auth/components/login/extra-component/Google'
import { getContentImage } from '@inside-library/helpers/Image'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-auth': {
    extraComponent: {
      is: Google,
      link: `${origin}/saml/login`
    }
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true,
    extraCategoriesFilters: ['regional_directions']
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true,
    addContentTypes: {
      homepage: ['news', 'events', 'blocks', 'cards_links', 'flash_news']
    },
    gdprContent: 'popins'
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true,
    authorEnabled: true,
    extraCategoriesFilters: ['regional_directions'],
    templates: {
      fullContent: {
        relatedComponent: () => import('./components/news/MinimalNews'),
        relatedFields: () => [
          'image',
          'chapo',
          {
            news_categories: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          },
          {
            regional_directions: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          }
        ]
      }
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/news/MinimalNews'),
        displayAttributes: ({ item }) => ({
          to: {
            name: 'NewsPage',
            params: { slug: item.slug[0] }
          }
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'title',
            'chapo',
            'slug',
            'image',
            'published_at',
            'content_type',
            {
              news_categories: ['uuid', 'title']
            },
            {
              regional_directions: ['uuid', 'title']
            }
          ],
          filters: {
            'status:eq': 1
          },
          valueCallback: item => item.uuid_host,
          labelCallback: item => item.title
        },
        requestFields: [
          'uuid',
          'title',
          'chapo',
          'slug',
          'image',
          'published_at',
          'content_type',
          {
            news_categories: ['uuid', 'title']
          },
          {
            regional_directions: ['uuid', 'title']
          }
        ]
      }
    }
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('@inside-customs/components/directory/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        requestFields: ['uuid', 'firstname', 'lastname', 'image', 'email']
      }
    }
  }
}
