<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddRegionalDirectionForContents extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('regional_directions');
        $this->call('models:rebuild');
        $this->finishUp();

        $this->seedDirections();

        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            'news',
            'regional_directions',
            [
                'name' => 'regional_directions',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => true,
                'weight' => 3,
                'title' => [
                    'fr' => 'Direction Régionale',
                    'en' => 'Regional Directorate',
                    'nl' => 'Regionale Directie',
                    'pt' => 'Direção Regional',
                    'es' => 'Dirección Regional',
                    'de' => 'Regionale Direktion'
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 9,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['regional_directions'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            3
        );
        $bridge->contentTypeCreateOrUpdateField(
            'events',
            'regional_directions',
            [
                'name' => 'regional_directions',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => true,
                'weight' => 3,
                'title' => [
                    'fr' => 'Direction Régionale',
                    'en' => 'Regional Directorate',
                    'nl' => 'Regionale Directie',
                    'pt' => 'Direção Regional',
                    'es' => 'Dirección Regional',
                    'de' => 'Regionale Direktion'
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 9,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['regional_directions'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            3
        );
    }

    private function seedDirections(): void
    {
        $bridge = new BridgeContent();
        collect([
            'Arcs de Seine',
            'Sud Ouest',
            'Nord Normandie',
            'Antilles Guyane',
            'Must',
            'Activités pénitentiaires',
            'Groupe',
            'Auvergne-Rhône-Alpes Méditerranée',
            'Grand Est',
            'Centre-Ouest',
            'Île-de-France'
        ])->each(
            function ($direction) use ($bridge) {
                if (!type_to_class('regional_directions')::where('title', $direction)->exists()) {
                    $bridge->contentInsert(
                        type: 'regional_directions',
                        data: [
                            'code' => str_replace(' ', '_', strtolower($direction)),
                            'title' => $direction
                        ],
                    );
                }
            }
        );
    }
}
