<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;

class IdexUpdateUserFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->updateContentTypeOptions(
            type: 'users',
            options: [
                'name' => 'users',
                'translatable' => true,
                'title' => [
                    'fr' => 'Utilisateur',
                    'en' => 'User',
                    'nl' => 'Gebruiker',
                    'pt' => 'Utilizador',
                    'es' => 'Espace métier',
                    'de' => 'Benutzer',
                ],
            ]
        );
        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'function');
        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'phone');
        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'entities');
        Artisan::call("models:rebuild");

        $this->migrateContent('entities', false);
        $this->migrateContent('trades', false);
        $this->migrateContent('business_units', false);
        $this->migrateContent('users', false);
        $this->finishUp();
    }
}
