<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class CreateIdexMissingContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('spaces');
        $this->migrateContent('pages_categories');
        $this->migrateContent('spaces_pages');
        $this->migrateContent('marker');
        $this->migrateContent('entities');

        $this->finishUp();

        $bridge = new BridgeContentType();
        $bridge->updateFieldOptions('users', 'phone', ['editable' => true]);
        $bridge->updateFieldOptions('users', 'function', ['editable' => true]);
        $bridge->contentTypeDeleteField('user', 'user', 'birthday');
        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'entities',
            [
                'name' => 'entities',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Entité',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 3,
                ],
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            3
        );
    }
}
