<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'events',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Événement',
            'en' => 'Event',
            'nl' => 'Evenement',
            'pt' => 'Evento',
            'es' => 'Evento',
            'de' => 'Vorfall',
        ],
    ],
    'fields' => [
        [
            'name' => 'date',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Date de début',
                'en' => 'Start date',
                'nl' => 'Startdatum',
                'pt' => 'Data de início',
                'es' => 'Fecha de inicio',
                'de' => 'Anfangsdatum',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'end_date',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Date de fin',
                'en' => 'End date',
                'nl' => 'Einddatum',
                'pt' => 'Data final',
                'es' => 'Fecha final',
                'de' => 'Endtermin',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'display_hours',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Afficher les heures',
                'en' => 'Display hours',
                'nl' => 'Toon tijden',
                'pt' => 'Tempos de exposição',
                'es' => 'Mostrar horas',
                'de' => 'Stunden anzeigen',
            ],
            'description' => [
                'fr' => 'Afficher les horaires de l\'événement dans les listing et sur la page de l\'évenement',
                'en' => 'Display event times in listings and on event page',
                'nl' => 'Geef evenementtijden weer in vermeldingen en op de evenementpagina',
                'pt' => 'Mostrar os horários dos eventos na listagem e na página do evento',
                'es' => 'Mostrar horarios de eventos en listados y en la página de eventos',
                'de' => 'Zeigen Sie Veranstaltungszeiten in Listen und auf der Veranstaltungsseite an',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => true,
        ],
        [
            'name' => 'place',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Lieu',
                'en' => 'Place',
                'nl' => 'Plaats',
                'pt' => 'Localização',
                'es' => 'Lugar',
                'de' => 'Stelle',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'nl' => 'Afbeelding',
                'pt' => 'Imagem',
                'es' => 'Imagen',
                'de' => 'Bild',
            ],
            'description' => [
                'fr' => 'Cette image remonte sur votre événement',
                'en' => 'This image goes back to your event',
                'nl' => 'Deze afbeelding gaat terug naar jouw evenement',
                'pt' => 'Esta imagem sobe no seu evento',
                'es' => 'Esta imagen se remonta a su evento',
                'de' => 'Dieses Bild geht auf Ihre Veranstaltung zurück',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'nl' => 'Inhoud',
                'pt' => 'Conteúdo',
                'es' => 'Contenido',
                'de' => 'Inhalt',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up the page',
                'nl' => 'Selecteer de verschillende soorten alinea\'s die u naar boven op de pagina wilt verplaatsen',
                'pt' => 'Seleccione os diferentes tipos de parágrafos que deseja mover para cima da página',
                'es' => 'Seleccione los diferentes tipos de párrafos que desea mover hacia arriba en la página',
                'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'events_categories',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Catégorie(s) de l\'événement',
                'en' => 'Category(ies) of the event',
                'nl' => 'Evenementcategorie(ën)',
                'pt' => 'Categoria(s) do(s) evento(s)',
                'es' => 'Categoría(s) del evento',
                'de' => 'Kategorie(n) der Veranstaltung',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['events_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'comments',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Commentaires',
                'en' => 'Comments',
                'nl' => 'Opmerkingen',
                'pt' => 'Comentários',
                'es' => 'Comentarios',
                'de' => 'Kommentare',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::COMMENT_FIELD,
            'settings' => [
                'comment_type' => 'comments',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'registration_enabled',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Activer l\'inscription aux événements',
                'en' => 'Enable event registration',
                'nl' => 'Inschrijving voor evenementen inschakelen',
                'pt' => 'Ativar inscrição em eventos',
                'es' => 'Activar la inscripción a eventos',
                'de' => 'Aktiviere die Anmeldung zu Veranstaltungen',
            ],
            'description' => [
                'fr' => 'Cocher cette case si vous souhaitez que les utilisateurs puissent s\'inscrire à l\'événement',
                'en' => 'Display event times in listings and on event page',
                'nl' => 'Vink dit vakje aan als u wilt dat gebruikers zich kunnen registreren voor het evenement',
                'pt' => 'Mostrar os horários dos eventos na listagem e na página do evento',
                'es' => 'Mostrar horarios de eventos en listados y en la página de eventos',
                'de' => 'Zeigen Sie Veranstaltungszeiten in Listen und auf der Veranstaltungsseite an',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 8,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'participants_number',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Nombre de participants',
                'en' => 'Number of participants',
                'nl' => 'Aantal deelnemers',
                'pt' => 'Número de participantes',
                'es' => 'Número de participantes',
                'de' => 'Zahl der Teilnehmer',
            ],
            'description' => [
                'fr' => 'Choisissez combien d\'utilisateurs maximum peuvent s\'inscrire à l\'événement. Si le nombre d\'inscrit est atteint alors les utilisateurs ne pourront plus s\'inscrire et verront la notion "Complet"',
                'en' => 'Display event times in listings and on event page',
                'nl' => 'Kies hoeveel gebruikers zich maximaal kunnen registreren voor het evenement. Als het aantal geregistreerde gebruikers is bereikt, kunnen gebruikers zich niet meer registreren en krijgen ze de melding "Voltooid" te zien.',
                'pt' => 'Mostrar os horários dos eventos na listagem e na página do evento',
                'es' => 'Mostrar horarios de eventos en listados y en la página de eventos',
                'de' => 'Zeigen Sie Veranstaltungszeiten in Listen und auf der Veranstaltungsseite an',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 9,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
