<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/idex-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#E4492D',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#AC0066',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#E4492D',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#AC0066',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'mediatheque',
                'sectionTextColor' => '#AC0066'
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#AC0066',
        'links' => [
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/idex-groupe/',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/idex_groupe/',
            ],
            'facebook' => [
                'url' => 'https://www.facebook.com/Idexgroupe/',
            ],
            'twitter' => [
                'url' => 'https://x.com/Idexgroupe',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/c/IdexGroupe',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
