<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Eloquent\Collection;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Permission\Models\Role;
use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class RemoveRegionalDirectionCategories extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    private const REGIONAL_DIRECTIONS = [
        'Arcs de Seine',
        'Sud Ouest',
        'Nord Normandie',
        'Antilles Guyane',
        'Must',
        'Activités pénitentiaires',
        'Groupe',
        'Auvergne-Rhône-Alpes Méditerranée',
        'Grand Est',
        'Centre-Ouest',
        'Île-de-France'
    ];

    public function up(): void
    {
        $bridge = new BridgeContent();

        $newsCategories = type_to_class('news_categories')::whereIn('title', self::REGIONAL_DIRECTIONS)->get();
        foreach ($newsCategories as $cat) {
            $bridge->contentDelete('news_categories', $cat->uuid);
        }

        $eventCategories = type_to_class('events_categories')::whereIn('title', self::REGIONAL_DIRECTIONS)->get();
        foreach ($eventCategories as $cat) {
            $bridge->contentDelete('events_categories', $cat->uuid);
        }
    }
}
