<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Log;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Permission\Models\Role;
use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class AttachRegionalDirectionToContents extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    private const REGIONAL_DIRECTIONS = [
        'Arcs de Seine',
        'Sud Ouest',
        'Nord Normandie',
        'Antilles Guyane',
        'Must',
        'Activités pénitentiaires',
        'Groupe',
        'Auvergne-Rhône-Alpes Méditerranée',
        'Grand Est',
        'Centre-Ouest',
        'Île-de-France'
    ];

    public function up(): void
    {
        $bridge = new BridgeContent();
        $regionalDiections = type_to_class('regional_directions')::all()->pluck('uuid', 'title');

        // update news
        $newsCollection = type_to_class('news')::where('langcode', 'fr')->get();
        foreach ($newsCollection as $news) {
            $currentCategories = $news->newsCategories->pluck('uuid', 'title');
            $newCategories = $currentCategories->reject(
                fn ($uuid, $title) => in_array($title, self::REGIONAL_DIRECTIONS)
            );
            $newRegionalDirections = $regionalDiections->filter(
                fn ($uuid, $title) => in_array($title, $currentCategories->keys()->toArray())
            );

            if ($newCategories->isEmpty()) {
                Log::warning('Category news not found -> replaced by Energies humaines :' . $news->uuid);
                $newCategories = collect([
                    'Energies humaines' => 'dee4c598-94a5-496a-8ba1-f8818eeeb8b6'
                ]);
            }
            if ($newRegionalDirections->isEmpty()) {
                Log::warning('Can not update regional direction for news :' . $news->uuid);
                continue;
            }

            $bridge->contentUpdate('news', [
                'uuid' => $news->uuid,
                'regional_directions' => $newRegionalDirections->values()->toArray(),
                'news_categories' => $newCategories->values()->toArray()
            ]);
        }

        // update events
        $events = type_to_class('events')::where('langcode', 'fr')->get();
        foreach ($events as $event) {
            $currentCategories = $event->eventsCategories->pluck('uuid', 'title');

            $eventCategories = $currentCategories->reject(
                fn ($uuid, $title) => in_array($title, self::REGIONAL_DIRECTIONS)
            );

            $newRegionalDirections = $regionalDiections->filter(
                fn ($uuid, $title) => in_array($title, $currentCategories->keys()->toArray())
            );

            if ($eventCategories->isEmpty()) {
                Log::warning('Category event not found -> replaced by Internes :' . $event->uuid);
                $eventCategories = collect([
                    'Internes' => '99c85cff-f1c1-4513-a8b6-d0dda98a26ca'
                ]);
            }

            if ($newRegionalDirections->isEmpty()) {
                Log::warning('Can not update regional direction for event :' . $event->uuid);
                continue;
            }

            $bridge->contentUpdate('events', [
                'uuid' => $event->uuid,
                'regional_directions' => $newRegionalDirections->values()->toArray(),
                'events_categories' => $eventCategories->values()->toArray()
            ]);
        }
    }
}
