<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class IdexIndexAccordion extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        if (! Schema::hasSectionType('accordion')) {
            return;
        }
        $bridge = new BridgeContentType();
        $bridge->updateFieldOptions(
            type: 'accordion',
            fieldName: 'question',
            options: [
                'searchable' => true,
            ],
        );
        $bridge->updateFieldOptions(
            type: 'accordion',
            fieldName: 'answer',
            options: [
                'searchable' => true,
            ],
        );

        Artisan::call("index:rebuild", ['--type' => 'pages']);
    }
}
