<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;

class IdexRemoveFromPerms extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        collect(['entities', 'business_units','trades'])->each(
            fn ($type) => $this->getBridge()?->updateContentTypeOptions(
                type: $type,
                options: [
                    'permissible' => false,
                    'categorizable' => false,
                ]
            )
        );
        Artisan::call("inside:permission:fix");
    }
}
