<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Inside\Host\Bridge\BridgeContent;

class IdexRenameTechniqueAccount extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContent();

        collect([
            'admin@maecia.com',
            'marine.martins@maecia.com'
        ])->each(function ($email) use ($bridge) {
            $user = type_to_class('users')::where('email', $email)->first();
            if ($user->uuid) {
                $uuid = $user->uuid;
                DB::transaction(function () use ($bridge, $uuid) {
                    DB::table('inside_content_comments')->where('author', $uuid)->delete();
                    DB::table('inside_section_slide')->where('author', $uuid)->delete();
                    $bridge->contentDelete('users', $uuid);
                });
            }
        });

        $usersToRename = [
            'webmaster@maecia.com' => [
                'email' => 'marine.martins@maecia.com',
                'name' => 'marine.martins',
                'firstname' => 'Marine',
                'lastname' => 'Martins',
            ],
            'technique@maecia.com' => [
                'email' => 'pierre.ribault@maecia.com',
                'name' => 'pierre.ribault',
                'firstname' => 'Pierre',
                'lastname' => 'Ribault',
            ]
        ];

        collect($usersToRename)->each(function ($userData, $email) use ($bridge) {
            $user = type_to_class('users')::where('email', $email)->first();
            if ($user->uuid) {
                $bridge->contentUpdate('users', [
                    'uuid' => $user->uuid,
                    'email' => $userData['email'],
                    'name' => $userData['name'],
                    'firstname' => $userData['firstname'],
                    'lastname' => $userData['lastname']
                ]);
            }
        });
    }
}
