<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Collection;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\ToolsCategories;
use Inside\Content\Models\Contents\ToolsCategoriesListings;
use Inside\Database\Eloquent\Builder;
use Inside\Host\Bridge\BridgeContent;

class Sid2AddMissingTools extends Migration
{
    public function up(): void
    {
        $toolsCategoriesListings = type_to_class('tools_categories_listings')::query()->select('uuid', 'uuid_host', 'langcode')
            ->get()
            ->groupBy('uuid_host')
            ->toArray();

        $toolsCategoriesListings =         collect($toolsCategoriesListings)->mapWithKeys(
            fn ($toolCategoryListing, $toolCategoryListingUuidHost) => [
                $toolCategoryListingUuidHost => collect($toolCategoryListing)->map(
                    fn ($toolCategoryListingItem) => $toolCategoryListingItem['langcode']
                )
            ]
        );

        $toolsCategoriesListings->each(
            fn ($toolCategoryListingsLangcodes, $toolCategoryListingUuidHost) => $this->addMissingToolsCategories($toolCategoryListingsLangcodes, $toolCategoryListingUuidHost)
        );

        $toolsCategories = type_to_class('tools_categories')::query()->select('uuid_host', 'langcode')
            ->get()
            ->groupBy('uuid_host');

        $toolsCategories->each(
            fn ($toolCategoryLangcodes, $toolCategoryUuidHost) => $this->addMissingTools($toolCategoryLangcodes, $toolCategoryUuidHost)
        );
    }

    private function addMissingTools(Collection $toolCategoryLangcodes, string $toolCategoryUuidHost): void
    {
        $langcodes = $toolCategoryLangcodes->pluck('langcode');
        $bridge = new BridgeContent();
        $tools = type_to_class('tools')::with('ToolsCategories')
            ->whereHas(
                'ToolsCategories',
                fn (Builder $query) => $query->where('uuid_host', $toolCategoryUuidHost)
            )->select('uuid_host', 'title', 'langcode')
            ->get()
            ->groupBy('uuid_host')
            ->toArray();


        foreach ($tools as $toolsUuidHost => $tool) {
            $missingLangcodes = $langcodes->diff(collect($tool)->pluck('langcode'));
            $toolSource = $tool[0];
            $missingLangcodes->each(
                fn ($langcode) => $bridge->contentInsert(
                    type: 'tools',
                    data: [
                        'uuid_host' => $toolsUuidHost,
                        'title' => $toolSource['title'],
                        'langcode' => $langcode
                    ],
                    creation: true,
                    fromCli: true,
                    ignoreParagraphs: false
                )
            );
        }
    }

    private function addMissingToolsCategories(Collection $toolCategoryListingsLangcodes, string $toolCategoryListingUuidHost): void
    {
        $bridge = new BridgeContent();
        $toolsCategories = type_to_class('tools_categories')::with('ToolsCategoriesListings')
            ->whereHas(
                'ToolsCategoriesListings',
                fn (Builder $query) => $query->where('uuid_host', $toolCategoryListingUuidHost)
            )->select('uuid_host', 'title', 'langcode')
            ->get()
            ->groupBy('uuid_host')
            ->toArray();

        foreach ($toolsCategories as $toolsCategoryUuidHost => $toolsCategory) {
            $missingCategoriesLangcodes = $toolCategoryListingsLangcodes->diff(collect($toolsCategory)->pluck('langcode'));
            $toolsCategorySource = $toolsCategory[0];
            $missingCategoriesLangcodes->each(
                fn ($langcode) => $bridge->contentInsert(
                    type: 'tools_categories',
                    data: [
                        'uuid_host' => $toolsCategoryUuidHost,
                        'title' => $toolsCategorySource['title'],
                        'langcode' => $langcode
                    ],
                    creation: true,
                    fromCli: true,
                    ignoreParagraphs: false
                )
            );
        }
    }
}
