<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class MakeContentTranslatable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = collect([
            'pages',
            'dms_link',
            'movements',
            'connexion_popups',
            'top_footer',
            'public_pages'
        ]);

        $contentTypes->each(function ($contentType) use ($bridge) {
            $bridge->updateContentTypeOptions(
                type: $contentType,
                options: [
                    'translatable' => true,
                ]
            );
            $bridge->changeFieldFormOptions($contentType, 'langcode', true, 'group_advanced_options');
        });

        Artisan::call('models:rebuild');
    }
}
