<?php


use Google\Service\PeopleService;
use Google\Service\PeopleService\Photo;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Support\Arr;
use Inside\Content\Models\Contents\Companies;
use Inside\Content\Models\Contents\Services;
use Inside\Content\Models\Contents\Users;
use Inside\Facades\Http;
use Inside\User\Models\User;

return [
    'scopes' => [
        'https://www.googleapis.com/auth/admin.directory.user.readonly',
        'https://www.googleapis.com/auth/admin.directory.group.readonly',
        'https://www.googleapis.com/auth/admin.directory.group.member.readonly'
    ],
    'sync_attributes' => [
        'mail' => 'getPrimaryEmail',
        'name' => 'getPrimaryEmail',
        'firstname' => fn (\Google_Service_Directory_User $user) => data_get($user, 'name.givenName'),
        'lastname' => fn (\Google_Service_Directory_User $user) => data_get($user, 'name.familyName'),
        'function' => fn (\Google_Service_Directory_User $user) => Arr::get(data_get($user, 'organizations', []), '0.title'),
        'entities' => fn (\Google_Service_Directory_User $user) => reference('entities')
            ->identifiedBy('code')
            ->from(ucfirst(strtolower(data_get($user->getCustomSchemas(), 'Extension_Attributes.Region', ''))))
            ->get(),
        'phone' => fn (\Google_Service_Directory_User $user) => data_get(collect($user->getPhones())->firstWhere('type', 'mobile'), 'value'),
        'trades' =>  fn (\Google_Service_Directory_User $user) => reference('trades')
            ->identifiedBy('code')
            ->from(ucfirst(strtolower(data_get($user->getCustomSchemas(), 'Extension_Attributes.Fonction', ''))))
            ->get(),
        'business_units' => fn (\Google_Service_Directory_User $user) => reference('business_units')
            ->identifiedBy('code')
            ->from(ucfirst(strtolower(data_get($user->getCustomSchemas(), 'Extension_Attributes.BU', ''))))
            ->get(),
        'image' => fn (\Google_Service_Directory_User $user) => avatar($user->getThumbnailPhotoUrl(), User::query()->where('email', $user->getPrimaryEmail())->first()),
        'is_external_user' => fn (\Google_Service_Directory_User $user) => $user->orgUnitPath === '/OU Utilisateurs Externes',
        'status' => fn () => true,
    ],
    'org_unit_paths' => [
        'idex' => '/IDEX',
        'mgd' => '/MGD',
        'externes' => '/OU Utilisateurs Externes',
    ]
];
