import { http } from '@inside-library/helpers/Http'

const hrDocRedirection = async ({ data }) => {
  try {
    let folderUuid = data.uuid

    if (data.content_type === 'rcp_documents') {
      const { data: docData } = await http.get('content/rcp_documents', {
        filters: {
          'uuid:eq': data.uuid
        },
        fields: [{ rcp_folders: ['uuid'] }]
      })

      folderUuid = docData[0].rcp_folders.uuid
    }

    const { data: folderData } = await http.get('content/rcp_folders', {
      filters: {
        'uuid:eq': folderUuid
      },
      fields: ['uuid']
    })

    return `/reunions-de-concertation-pluridisciplinaires?folder=${folderData[0].uuid}`
  } catch (err) {
    throw new Error(err)
  }
}

const dutiesRedirection = async ({ fields }) => {
  try {
    const { data: dutiesServiceData } = await http.get(
      'content/duties_services',
      {
        filters: {
          'uuid:eq': fields.duties_services
        },
        fields: ['slug']
      }
    )

    return {
      name: 'ServicesDutiesPage',
      params: {
        slug: dutiesServiceData[0].slug[0]
      }
    }
  } catch (err) {
    throw new Error(err)
  }
}

const spacesRedirection = async ({ data }) => {
  try {
    const { data: spaceData } = await http.get('content/spaces', {
      filters: {
        'uuid:eq': data.uuid
      },
      fields: ['slug']
    })

    return {
      name: 'SpacesPage',
      params: { slug: spaceData[0].slug[0] }
    }
  } catch (err) {
    throw new Error(err)
  }
}

const spacesPagesRedirection = async data => {
  const uuid = data.field?.uuid || data.uuid
  try {
    const { data: pages } = await http.get('content/spaces_pages', {
      filters: {
        'uuid:eq': uuid
      },
      fields: ['slug', { spacesCategories: { fields: ['uuid', 'slug'] } }]
    })

    const { data: slug } = await http.get('content/spaces_categories', {
      filters: {
        'uuid:eq': pages[0].spacesCategories[0].uuid
      },
      fields: ['slug', { spaces: { fields: ['uuid', 'slug'] } }]
    })

    return {
      name: 'SpacesPagesPage',
      params: {
        slug: slug[0].spaces.data[0].slug[0],
        pages: pages[0].slug[0]
      }
    }
  } catch (err) {
    throw new Error(err)
  }
}

export default {
  events: {
    add: ({ data }) => ({
      name: 'EventPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'EventsListingPage' })
  },
  eventsCategories: {
    add: () => ({ name: 'EventsListingPage' }),
    delete: () => ({ name: 'EventsListingPage' })
  },
  jobs: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' })
  },
  rcpServices: {
    add: () => ({ name: 'RcpPage' }),
    delete: () => ({ name: 'RcpPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  rcpDocuments: {
    add: hrDocRedirection,
    delete: hrDocRedirection,
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  rcpFolders: {
    extends: 'rcpDocuments'
  },
  dedicatedPremises: {
    add: () => ({ name: 'DedicatedPremisesPage' }),
    delete: () => ({ name: 'DedicatedPremisesPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  duties: {
    add: dutiesRedirection,
    delete: dutiesRedirection
  },
  dutiesServices: {
    add: async ({ data }) => ({
      name: 'ServicesDutiesPage',
      params: {
        slug: data.slug[0]
      }
    })
  },
  spaces: {
    add: spacesRedirection,
    delete: spacesRedirection
  },
  spacesPages: {
    add: spacesPagesRedirection,
    delete: spacesPagesRedirection
  },
  menuSelf: {
    add: () => ({ name: 'SelfListingPage' }),
    delete: () => ({ name: 'SelfListingPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  }
}
