import { http } from '@inside-library/helpers/Http'

export const fetchRcpServices = async () => {
  try {
    const { data: services } = await http.get('content/rcp_services', {
      fields: [
        'uuid',
        'title',
        'time',
        'admin',
        {
          doctor: [
            'uuid',
            'firstname',
            'lastname',
            'email',
            'phone',
            { users_titles: ['title'] }
          ]
        },
        {
          secretary: ['uuid', 'firstname', 'lastname', 'email', 'phone']
        },
        'periodicity',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        sort: ['weight:asc']
      }
    })
    const { data } = await http.get('content/rcp_spaces', {
      fields: ['uuid', 'content']
    })

    return { services, content: data[0].content }
  } catch (err) {
    throw new Error(err)
  }
}
