import { http } from '@inside-library/helpers/Http'

const fetchNewsSlider = async () => {
  try {
    const { data } = await http.get('content/news,forms', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'updated_at',
        'chapo',
        'slug',
        'content_type',
        'is_featured',
        { reactions: ['count', { users: ['uuid'] }] },
        { comments: ['count'] },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'is_featured:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 4
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchNewsSlider }
