import ServicesDutiesPage from '../pages/services-duties/ServicesDutiesPage'
import { fetchServicesDuties } from '../fetch/services'

import RcpPage from '../pages/rcp/RcpPage'
import { fetchRcpServices } from '../fetch/rcpServices'

import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import { fetchSpacesPage, fetchSpacesPagesPage } from '../fetch/spaces'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    component: () => import('../pages/GedPage')
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false },
    props: {
      bannerData: {
        imageKey: 'banner'
      }
    }
  },
  {
    name: 'DirectoryPage',
    path: '/equipes',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'DedicatedPremisesPage',
    path: '/annuaire-des-locaux-dedies',
    component: () => import('../pages/dedicated-premises/DedicatedPremisesPage')
  },
  {
    name: 'SelfListingPage',
    path: '/le-menu-du-self',
    component: () => import('../pages/self/SelfListingPage')
  },
  {
    name: 'WeeklyServicesDutiesPage',
    path: '/astreintes',
    component: () => import('../pages/services-duties/WeeklyServicesDutiesPage')
  },
  {
    name: 'ServicesDutiesPage',
    path: '/astreintes/:slug',
    component: withFetch(ServicesDutiesPage, { size: 'xxl', watch: true })(
      fetchServicesDuties
    )
  },
  {
    name: 'RcpPage',
    path: '/reunions-de-concertation-pluridisciplinaires',
    component: withFetch(RcpPage, { size: 'xxl', watch: true })(
      fetchRcpServices
    )
  },
  {
    name: 'JobsListingPage',
    path: '/offres-d-emploi',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/:slug/:pages',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'ListingCoursesCategoriesPage',
    props: {
      bannerImageKey: 'banner'
    }
  },
  {
    name: 'CoursesListingPage',
    props: {
      bannerImageKey: 'banner'
    }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  }
]
