import { formatHref } from '@inside-library/helpers/Langs'

export default {
  globals: {
    notificationRedirectionsContentTypes: ['pages'],
    notificationRedirections: {
      pages: async ({ data }) => ({
        name: 'SimplePage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-commons': {
    banner: {
      imageKey: 'image'
    }
  },
  'inside-administration': {
    subModules: ['inside-mailings', 'inside-statistics']
  },
  'inside-auth': {
    loginForm: {
      userId: {
        modelName: 'name',
        inputType: 'text'
      }
    }
  },
  'inside-ged': {
    useV2: true,
    rootRoute: {
      fr: 'bibliotheque-de-ressources'
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    paragraphs: {
      fetchedContents: {
        displayAttributes: ({ item, lang }) => ({
          to: formatHref(
            {
              name: 'NewsPage',
              params: {
                slug: item.slug[0]
              }
            },
            lang
          )
        })
      }
    }
  },
  'inside-events': {
    paragraphs: {
      fetchedContents: {
        displayAttributes: ({ item, lang }) => ({
          to: formatHref(
            {
              name: 'EventPage',
              params: {
                slug: item.slug[0]
              }
            },
            lang
          )
        })
      }
    }
  },
  'inside-paragraphs': {
    fetchedContents: {
      availabledContentTypes: ['news', 'users', 'events', 'documents']
    }
  },
  'inside-users': {
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  }
}
